//-----------------------------------------------------------------------------
// Simple Text Editor Example for C#Builder
//
// FormDocument.cs
//
// This form represents a single MDI child and is used to edit a document.
// Multiple child forms can be created so that several documents can be edited
// at the same time.
//
// Jarrod Hollingworth
// http://www.csharpbuilder.info
//-----------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;

namespace TextEditor
{
	/// <summary>
	/// Summary description for WinForm1.
	/// </summary>
	public class frmDocument : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem miClose;
		private System.Windows.Forms.MenuItem miSave;
		private System.Windows.Forms.MenuItem miSaveAs;
		private System.Windows.Forms.MenuItem menuItem8;
    private System.Windows.Forms.RichTextBox rtxtDocument;
    private System.Windows.Forms.SaveFileDialog saveFileDialog1;
    private System.Windows.Forms.ContextMenu contextMenu1;
    private System.Windows.Forms.FontDialog fontDialog1;
    private System.Windows.Forms.MenuItem menuItem2;
    private System.Windows.Forms.MenuItem miCut;
    private System.Windows.Forms.MenuItem miCopy;
    private System.Windows.Forms.MenuItem miPaste;
    private System.Windows.Forms.MenuItem miSelectAll;
    private System.Windows.Forms.MenuItem menuItem14;
    private System.Windows.Forms.MenuItem miAlignLeft;
    private System.Windows.Forms.MenuItem miAlignRight;
    private System.Windows.Forms.MenuItem miAlignCentre;
    private System.Windows.Forms.MenuItem menuItem18;
    private System.Windows.Forms.MenuItem miWordWrap;
    private System.Windows.Forms.MenuItem menuItem20;
    private System.Windows.Forms.MenuItem miFont;
    private System.Windows.Forms.MenuItem miPopupCut;
    private System.Windows.Forms.MenuItem miPopupCopy;
    private System.Windows.Forms.MenuItem miPopupPaste;

    private string DocumentFileName = "";

		public frmDocument(string Title)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
      Text = Title;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
    {
      this.mainMenu1 = new System.Windows.Forms.MainMenu();
      this.menuItem1 = new System.Windows.Forms.MenuItem();
      this.miClose = new System.Windows.Forms.MenuItem();
      this.menuItem8 = new System.Windows.Forms.MenuItem();
      this.miSave = new System.Windows.Forms.MenuItem();
      this.miSaveAs = new System.Windows.Forms.MenuItem();
      this.menuItem2 = new System.Windows.Forms.MenuItem();
      this.miCut = new System.Windows.Forms.MenuItem();
      this.miCopy = new System.Windows.Forms.MenuItem();
      this.miPaste = new System.Windows.Forms.MenuItem();
      this.miSelectAll = new System.Windows.Forms.MenuItem();
      this.menuItem14 = new System.Windows.Forms.MenuItem();
      this.miAlignLeft = new System.Windows.Forms.MenuItem();
      this.miAlignRight = new System.Windows.Forms.MenuItem();
      this.miAlignCentre = new System.Windows.Forms.MenuItem();
      this.menuItem18 = new System.Windows.Forms.MenuItem();
      this.miWordWrap = new System.Windows.Forms.MenuItem();
      this.menuItem20 = new System.Windows.Forms.MenuItem();
      this.miFont = new System.Windows.Forms.MenuItem();
      this.rtxtDocument = new System.Windows.Forms.RichTextBox();
      this.contextMenu1 = new System.Windows.Forms.ContextMenu();
      this.miPopupCopy = new System.Windows.Forms.MenuItem();
      this.miPopupCut = new System.Windows.Forms.MenuItem();
      this.miPopupPaste = new System.Windows.Forms.MenuItem();
      this.saveFileDialog1 = new System.Windows.Forms.SaveFileDialog();
      this.fontDialog1 = new System.Windows.Forms.FontDialog();
      this.SuspendLayout();
      // 
      // mainMenu1
      // 
      this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.menuItem1,
            this.menuItem2,
            this.menuItem14});
      // 
      // menuItem1
      // 
      this.menuItem1.Index = 0;
      this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.miClose,
            this.menuItem8,
            this.miSave,
            this.miSaveAs});
      this.menuItem1.MergeType = System.Windows.Forms.MenuMerge.MergeItems;
      this.menuItem1.Text = "&File";
      // 
      // miClose
      // 
      this.miClose.Index = 0;
      this.miClose.MergeOrder = 10;
      this.miClose.Text = "&Close";
      this.miClose.Click += new System.EventHandler(this.miClose_Click);
      // 
      // menuItem8
      // 
      this.menuItem8.Index = 1;
      this.menuItem8.MergeOrder = 11;
      this.menuItem8.Text = "-";
      // 
      // miSave
      // 
      this.miSave.Index = 2;
      this.miSave.MergeOrder = 12;
      this.miSave.Text = "&Save";
      this.miSave.Click += new System.EventHandler(this.miSave_Click);
      // 
      // miSaveAs
      // 
      this.miSaveAs.Index = 3;
      this.miSaveAs.MergeOrder = 13;
      this.miSaveAs.Text = "Save &As...";
      this.miSaveAs.Click += new System.EventHandler(this.miSaveAs_Click);
      // 
      // menuItem2
      // 
      this.menuItem2.Index = 1;
      this.menuItem2.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.miCut,
            this.miCopy,
            this.miPaste,
            this.miSelectAll});
      this.menuItem2.MergeOrder = 1;
      this.menuItem2.Text = "&Edit";
      // 
      // miCut
      // 
      this.miCut.Index = 0;
      this.miCut.Shortcut = System.Windows.Forms.Shortcut.CtrlX;
      this.miCut.Text = "Cu&t";
      this.miCut.Click += new System.EventHandler(this.miCut_Click);
      // 
      // miCopy
      // 
      this.miCopy.Index = 1;
      this.miCopy.Shortcut = System.Windows.Forms.Shortcut.CtrlC;
      this.miCopy.Text = "&Copy";
      this.miCopy.Click += new System.EventHandler(this.miCopy_Click);
      // 
      // miPaste
      // 
      this.miPaste.Index = 2;
      this.miPaste.Shortcut = System.Windows.Forms.Shortcut.CtrlV;
      this.miPaste.Text = "&Paste";
      this.miPaste.Click += new System.EventHandler(this.miPaste_Click);
      // 
      // miSelectAll
      // 
      this.miSelectAll.Index = 3;
      this.miSelectAll.Shortcut = System.Windows.Forms.Shortcut.CtrlA;
      this.miSelectAll.Text = "&Select All";
      this.miSelectAll.Click += new System.EventHandler(this.miSelectAll_Click);
      // 
      // menuItem14
      // 
      this.menuItem14.Index = 2;
      this.menuItem14.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.miAlignLeft,
            this.miAlignRight,
            this.miAlignCentre,
            this.menuItem18,
            this.miWordWrap,
            this.menuItem20,
            this.miFont});
      this.menuItem14.MergeOrder = 2;
      this.menuItem14.Text = "For&mat";
      // 
      // miAlignLeft
      // 
      this.miAlignLeft.Index = 0;
      this.miAlignLeft.Text = "Align Left";
      this.miAlignLeft.Click += new System.EventHandler(this.miAlignLeft_Click);
      // 
      // miAlignRight
      // 
      this.miAlignRight.Index = 1;
      this.miAlignRight.Text = "Align Right";
      this.miAlignRight.Click += new System.EventHandler(this.miAlignRight_Click);
      // 
      // miAlignCentre
      // 
      this.miAlignCentre.Index = 2;
      this.miAlignCentre.Text = "Align Centre";
      this.miAlignCentre.Click += new System.EventHandler(this.miAlignCentre_Click);
      // 
      // menuItem18
      // 
      this.menuItem18.Index = 3;
      this.menuItem18.Text = "-";
      // 
      // miWordWrap
      // 
      this.miWordWrap.Checked = true;
      this.miWordWrap.Index = 4;
      this.miWordWrap.Text = "Word Wrap";
      this.miWordWrap.Click += new System.EventHandler(this.miWordWrap_Click);
      // 
      // menuItem20
      // 
      this.menuItem20.Index = 5;
      this.menuItem20.Text = "-";
      // 
      // miFont
      // 
      this.miFont.Index = 6;
      this.miFont.Text = "Font...";
      this.miFont.Click += new System.EventHandler(this.miFont_Click);
      // 
      // rtxtDocument
      // 
      this.rtxtDocument.BorderStyle = System.Windows.Forms.BorderStyle.None;
      this.rtxtDocument.ContextMenu = this.contextMenu1;
      this.rtxtDocument.Dock = System.Windows.Forms.DockStyle.Fill;
      this.rtxtDocument.Location = new System.Drawing.Point(0, 0);
      this.rtxtDocument.Name = "rtxtDocument";
      this.rtxtDocument.ScrollBars = System.Windows.Forms.RichTextBoxScrollBars.Vertical;
      this.rtxtDocument.Size = new System.Drawing.Size(424, 234);
      this.rtxtDocument.TabIndex = 0;
      this.rtxtDocument.Text = "";
      // 
      // contextMenu1
      // 
      this.contextMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.miPopupCopy,
            this.miPopupCut,
            this.miPopupPaste});
      // 
      // miPopupCopy
      // 
      this.miPopupCopy.Index = 0;
      this.miPopupCopy.Shortcut = System.Windows.Forms.Shortcut.CtrlC;
      this.miPopupCopy.Text = "&Copy";
      this.miPopupCopy.Click += new System.EventHandler(this.miCopy_Click);
      // 
      // miPopupCut
      // 
      this.miPopupCut.Index = 1;
      this.miPopupCut.Shortcut = System.Windows.Forms.Shortcut.CtrlX;
      this.miPopupCut.Text = "Cu&t";
      this.miPopupCut.Click += new System.EventHandler(this.miCut_Click);
      // 
      // miPopupPaste
      // 
      this.miPopupPaste.Index = 2;
      this.miPopupPaste.Shortcut = System.Windows.Forms.Shortcut.CtrlV;
      this.miPopupPaste.Text = "&Paste";
      this.miPopupPaste.Click += new System.EventHandler(this.miPaste_Click);
      // 
      // saveFileDialog1
      // 
      this.saveFileDialog1.DefaultExt = "*.rtf";
      this.saveFileDialog1.Filter = "Rich text files (*.rtf)|*.rtf|Plain text files (*.txt)|*.txt|All f" +  
        "iles (*.*)|*.*";
      // 
      // frmDocument
      // 
      this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
      this.ClientSize = new System.Drawing.Size(424, 234);
      this.Controls.Add(this.rtxtDocument);
      this.Menu = this.mainMenu1;
      this.Name = "frmDocument";
      this.Text = "Untitled";
      this.Closing += new System.ComponentModel.CancelEventHandler(this.frmDocument_Closing);
      this.ResumeLayout(false);
    }
		#endregion

    public void Open(string FileNameAndPath)
    {
      if (Path.GetExtension(FileNameAndPath).IndexOf("rtf") >= 0) {
        rtxtDocument.LoadFile(FileNameAndPath);
      } else {
        rtxtDocument.LoadFile(FileNameAndPath, RichTextBoxStreamType.PlainText);
      }
      this.Text = Path.GetFileName(FileNameAndPath);
      DocumentFileName = FileNameAndPath;
      rtxtDocument.Modified = false;
    }

    public void SaveDocument(string FileNameAndPath)
    {
      if (Path.GetExtension(FileNameAndPath).IndexOf("rtf") >= 0) {
        rtxtDocument.SaveFile(FileNameAndPath);
      } else {
        rtxtDocument.SaveFile(FileNameAndPath, RichTextBoxStreamType.PlainText);
      }
      this.Text = Path.GetFileName(FileNameAndPath);
      rtxtDocument.Modified = false;
      DocumentFileName = FileNameAndPath;
    }

    public bool SaveAs(string FileNameAndPath)
    {
      saveFileDialog1.FileName = FileNameAndPath;
      if (saveFileDialog1.ShowDialog() == DialogResult.OK) {
        SaveDocument(saveFileDialog1.FileName);
        return true;
      } else {
        return false;
      }
    }

    private void miCopy_Click(object sender, System.EventArgs e)
    {
      rtxtDocument.Copy();
    }

    private void miCut_Click(object sender, System.EventArgs e)
    {
      rtxtDocument.Cut();
    }

    private void miPaste_Click(object sender, System.EventArgs e)
    {
      rtxtDocument.Paste();
    }

    private void miClose_Click(object sender, System.EventArgs e)
    {
      Close();
    }

    private void miSave_Click(object sender, System.EventArgs e)
    {
      if (DocumentFileName.Length == 0) {
        SaveAs(DocumentFileName);
      } else {
        SaveDocument(DocumentFileName);
      }
    }

    private void miSaveAs_Click(object sender, System.EventArgs e)
    {
      SaveAs(DocumentFileName);
    }

    private void miSelectAll_Click(object sender, System.EventArgs e)
    {
      rtxtDocument.SelectAll();
    }

    private void miAlignLeft_Click(object sender, System.EventArgs e)
    {
      rtxtDocument.SelectionAlignment = HorizontalAlignment.Left;
    }

    private void miAlignRight_Click(object sender, System.EventArgs e)
    {
      rtxtDocument.SelectionAlignment = HorizontalAlignment.Right;
    }

    private void miAlignCentre_Click(object sender, System.EventArgs e)
    {
      rtxtDocument.SelectionAlignment = HorizontalAlignment.Center;
    }

    private void miWordWrap_Click(object sender, System.EventArgs e)
    {
      rtxtDocument.WordWrap = !rtxtDocument.WordWrap;
      if (rtxtDocument.WordWrap) {
        rtxtDocument.ScrollBars = RichTextBoxScrollBars.Vertical;
      } else {
        rtxtDocument.ScrollBars = RichTextBoxScrollBars.Both;
      }
      miWordWrap.Checked = rtxtDocument.WordWrap;
    }

    private void miFont_Click(object sender, System.EventArgs e)
    {
      if (fontDialog1.ShowDialog() == DialogResult.OK) {
        rtxtDocument.SelectionFont = fontDialog1.Font;
      }
    }

    private void frmDocument_Closing(object sender, System.ComponentModel.CancelEventArgs e)
    {
      if (rtxtDocument.Modified) {
        DialogResult Result = MessageBox.Show(this.Text + " has been modified. Save Changes?",
                                              this.Text, MessageBoxButtons.YesNoCancel);
        if (Result == DialogResult.Yes) {
          if (DocumentFileName.Length == 0) {
            e.Cancel = !SaveAs(DocumentFileName);
          } else {
            SaveDocument(DocumentFileName);
          }
       } else if (Result == DialogResult.Cancel) {
          e.Cancel = true;
        }
      }
    }
	}
}
